#!/usr/env/python3

"""Generate changes to xcodeproj file
"""


def main():
    def for_each_framework(block):
        for framework_number in range(1, 101):
            framework_name = f'FW{framework_number}'
            block(framework_number, framework_name)

    print('\n\n>>> Insert in PBXBuildFile section')
    for_each_framework(lambda number, name: print(
        f'''file.{name}.{name}.h = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}.h; settings = {{ATTRIBUTES = (Public, ); }}; }};
file.{name}.{name}Functions.c = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}Functions.c; }};
file.{name}.{name}Functions.h = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}Functions.h; settings = {{ATTRIBUTES = (Public, ); }}; }};
file.{name}.{name}Classes.swift = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}Classes.swift; }};
file.{name}.{name}Classes.h = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}Classes.h; settings = {{ATTRIBUTES = (Public, ); }}; }};'''))

    print('\n\n>>> Insert in PBXFileReference section')
    for_each_framework(lambda number, name: print(
      f'''fileref.{name}.{name}Classes.swift = {{isa = PBXFileReference; lastKnownFileType = sourcecode.swift; path = {name}Classes.swift; sourceTree = "<group>"; }};
fileref.{name}.{name}.h = {{isa = PBXFileReference; lastKnownFileType = sourcecode.c.h; path = {name}.h; sourceTree = "<group>"; }};
fileref.{name}.{name}Functions.c = {{isa = PBXFileReference; lastKnownFileType = sourcecode.c.c; path = {name}Functions.c; sourceTree = "<group>"; }};
fileref.{name}.{name}Classes.h = {{isa = PBXFileReference; lastKnownFileType = sourcecode.c.h; path = {name}Classes.h; sourceTree = "<group>"; }};
fileref.{name}.{name}Functions.h = {{isa = PBXFileReference; lastKnownFileType = sourcecode.c.h; path = {name}Functions.h; sourceTree = "<group>"; }};
fileref.{name}.{name}.framework = {{isa = PBXFileReference; explicitFileType = wrapper.framework; includeInIndex = 0; path = {name}.framework; sourceTree = BUILT_PRODUCTS_DIR; }};'''))

    print('\n\n>>> Insert in PBXGroup children list')
    for_each_framework(lambda number, name: print(f'group.{name},'))

    print('\n\n>>> Insert in PBXGroup section')
    for_each_framework(lambda number, name: print(
        f'''group.{name} = {{
    isa = PBXGroup;
    children = (
        fileref.{name}.{name}Functions.c,
        fileref.{name}.{name}Classes.h,
        fileref.{name}.{name}Functions.h,
        fileref.{name}.{name}Classes.swift,
        fileref.{name}.{name}.h,
    );
    path = {name};
    sourceTree = "<group>";
}};'''))

    print('\n\n>>> Insert in the Products children list')
    for_each_framework(lambda number, name: print(f'fileref.{name}.{name}.framework,'))

    print('\n\n>>> Insert in the PBXHeadersBuildPhase list')
    for_each_framework(lambda number, name: print(
        f'''phase.headers.{name}= {{
    isa = PBXHeadersBuildPhase;
    buildActionMask = 2147483647;
    files = (
        file.{name}.{name}Functions.h,
        file.{name}.{name}.h,
        file.{name}.{name}Classes.h,
    );
    runOnlyForDeploymentPostprocessing = 0;
}};'''))

    print('\n\n>>> Insert in PBXNativeTarget section')
    for_each_framework(lambda number, name:
                       print(f"""target.{name} = {{
    isa = PBXNativeTarget;
    buildConfigurationList = bcl.{name};
    buildPhases = (
        phase.headers.{name},
        phase.sources.{name}
    );
    buildRules = (
    );
    dependencies = (
    );
    name = {name};
    productName = {name};
    productReference = fileref.{name}.{name}.framework;
    productType = "com.apple.product-type.framework";
}};
"""))

    print('\n\n>>> Insert in PBXProject targets list')
    for_each_framework(lambda number, name: print(f'target.{name},'))

    print('\n\n>>> Insert in PBXSourcesBuildPhase section')
    for_each_framework(lambda number, name: print(
        f'''phase.sources.{name} = {{
    isa = PBXSourcesBuildPhase;
    buildActionMask = 2147483647;
    files = (
        file.{name}.{name}Classes.swift,
        file.{name}.{name}Functions.c,
    );
    runOnlyForDeploymentPostprocessing = 0;
}};
'''))

    print('\n\n>>> Insert in XCBuildConfiguration section')
    for_each_framework(lambda number, name: print(
        f'''buildconfig.{name}.Debug = {{
    isa = XCBuildConfiguration;
    buildSettings = {{
        CODE_SIGN_STYLE = Automatic;
        CURRENT_PROJECT_VERSION = 1;
        DEFINES_MODULE = YES;
        DEVELOPMENT_TEAM = H6H8M4XDDX;
        DYLIB_COMPATIBILITY_VERSION = 1;
        DYLIB_CURRENT_VERSION = 1;
        DYLIB_INSTALL_NAME_BASE = "@rpath";
        ENABLE_MODULE_VERIFIER = YES;
        GENERATE_INFOPLIST_FILE = YES;
        INFOPLIST_KEY_NSHumanReadableCopyright = "";
        INSTALL_PATH = "$(LOCAL_LIBRARY_DIR)/Frameworks";
        LD_RUNPATH_SEARCH_PATHS = (
            "$(inherited)",
            "@executable_path/Frameworks",
            "@loader_path/Frameworks",
        );
        MARKETING_VERSION = 1.0;
        MERGEABLE_LIBRARY = YES;
        MODULE_VERIFIER_SUPPORTED_LANGUAGES = "objective-c objective-c++";
        MODULE_VERIFIER_SUPPORTED_LANGUAGE_STANDARDS = "gnu17 gnu++20";
        PRODUCT_BUNDLE_IDENTIFIER = us.humancode.{name};
        PRODUCT_NAME = "$(TARGET_NAME)";
        SKIP_INSTALL = YES;
        SWIFT_EMIT_LOC_STRINGS = YES;
        TARGETED_DEVICE_FAMILY = "1,2";
        VERSIONING_SYSTEM = "apple-generic";
        VERSION_INFO_PREFIX = "";
    }};
    name = Debug;
}};
buildconfig.{name}.Release = {{
    isa = XCBuildConfiguration;
    buildSettings = {{
        CODE_SIGN_STYLE = Automatic;
        CURRENT_PROJECT_VERSION = 1;
        DEFINES_MODULE = YES;
        DEVELOPMENT_TEAM = H6H8M4XDDX;
        DYLIB_COMPATIBILITY_VERSION = 1;
        DYLIB_CURRENT_VERSION = 1;
        DYLIB_INSTALL_NAME_BASE = "@rpath";
        ENABLE_MODULE_VERIFIER = YES;
        GENERATE_INFOPLIST_FILE = YES;
        INFOPLIST_KEY_NSHumanReadableCopyright = "";
        INSTALL_PATH = "$(LOCAL_LIBRARY_DIR)/Frameworks";
        LD_RUNPATH_SEARCH_PATHS = (
            "$(inherited)",
            "@executable_path/Frameworks",
            "@loader_path/Frameworks",
        );
        MARKETING_VERSION = 1.0;
        MERGEABLE_LIBRARY = YES;
        MODULE_VERIFIER_SUPPORTED_LANGUAGES = "objective-c objective-c++";
        MODULE_VERIFIER_SUPPORTED_LANGUAGE_STANDARDS = "gnu17 gnu++20";
        PRODUCT_BUNDLE_IDENTIFIER = us.humancode.{name};
        PRODUCT_NAME = "$(TARGET_NAME)";
        SKIP_INSTALL = YES;
        SWIFT_EMIT_LOC_STRINGS = YES;
        TARGETED_DEVICE_FAMILY = "1,2";
        VERSIONING_SYSTEM = "apple-generic";
        VERSION_INFO_PREFIX = "";
    }};
    name = Release;
}};'''))

    print('\n\n>>> Insert in XCConfigurationList section')
    for_each_framework(lambda number, name: print(
        f'''bcl.{name} = {{
    isa = XCConfigurationList;
    buildConfigurations = (
        buildconfig.{name}.Debug,
        buildconfig.{name}.Release,
    );
    defaultConfigurationIsVisible = 0;
    defaultConfigurationName = Release;
}};'''))

    print('\n\n>>> Insert in PBXBuildFile section')
    for_each_framework(lambda number, name: print(
        f'file.{name}.framework = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}.framework; }};'))

    print('\n\n>>> Insert in PBXFrameworksBuildPhase files')
    for_each_framework(lambda number, name: print(f'file.{name}.framework,'))

    print('\n\n>>> Insert in Frameworks PBXGroup children')
    for_each_framework(lambda number, name: print(f'fileref.{name}.{name}.framework,'))

    print('\n\n>>> Insert in PBXBuildFile section')
    for_each_framework(lambda number, name: print(
        f'file.{name}.framework.embed = {{isa = PBXBuildFile; fileRef = fileref.{name}.{name}.framework; settings = {{ATTRIBUTES = (CodeSignOnCopy, RemoveHeadersOnCopy, ); }}; }};'))

    print('\n\n>>> Insert in PBXCopyFilesBuildPhase files')
    for_each_framework(lambda number, name: print(
        f'file.{name}.framework.embed,'))

if __name__ == '__main__':
    main()
