#!/bin/env python3

"""Generate the code that exercises the frameworks"""

def main():
    def for_each_framework(block):
        for framework_number in range(1, 101):
            framework_name = f'FW{framework_number}'
            block(framework_number, framework_name)

    for_each_framework(lambda number, name: print(f'#define EXERCISE_{name} 1'))
    print('')

    def print_imports(number, name):
        print(f'''#if defined(EXERCISE_{name}) && EXERCISE_{name}
#import <{name}/{name}.h>
#endif''')

    for_each_framework(print_imports)

    print('''int exerciseDependentFrameworks(void)
{
    int result = 0;
''')

    def exercise_functions(number, name):
        for function_number in range(1, 101):
            print(f'    result = {name}Function{function_number}(result);')

    def exercise_classes(number, name):
        for class_number in range(1, 51):
            class_name = f'{name}Class{class_number}'
            print(f'''    @autoreleasepool{{
        {class_name}* obj = [[{class_name} alloc] init];''')
            for method_number in range(1, 11):
                print(f'        result = [obj class{class_number}Method{method_number}WithParam:result];')
            print('    }')

    def exercise_framework(number, name):
        print(f'\n    /// Framework {number}')
        print(f'#if defined(EXERCISE_{name}) && EXERCISE_{name}')
        exercise_functions(number, name)
        exercise_classes(number, name)
        print(f'#endif // EXERCISE_{name}')

    for_each_framework(exercise_framework)

    print('''
    return result;
}''')


if __name__ == '__main__':
    main()